﻿/*
 * Created by SharpDevelop.
 * User: tianhao shi
 * Date: 02/02/2016
 * Time: 14:18
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Web.Script.Serialization;
using WComp.Beans;
using LocationInfo;

namespace WComp.Beans
{
	[Bean(Category="Perch")]
	public class Location
	{
      	private string locat;
      	private bool pressed;
      	
      	public bool Pressed {
      		get {
      			return pressed;
      		}
      		set {
      			pressed = value;
      			FireEvent(pressed);
      		}
      	}
      	
      	public string Locat {
            get { 
            	//FireEvent(location);
            	return locat; 
            }
        } 
      	
      	public string Lat {
            get { 
      			return locat.Split(',')[0];
            }
        } 
      	
      	public string Lon {
            get { 
      			return locat.Split(',')[1];
            }
        } 
      	
		public delegate void BooleanValueEventHandler(bool state);

		public event BooleanValueEventHandler PressedChanged;
		
		private void FireEvent(bool state) {
			if (PressedChanged != null){
				locat = GetValues();
				PressedChanged(state);
			}
		}
		
		private string GetValues() {
			var jsonConvert = new JavaScriptSerializer();
            string address = string.Format("http://ipinfo.io/json");
 
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(address);
            request.Method = "GET";
            request.Accept = "application/json";
            
            try
            {
                using (WebResponse response = request.GetResponse())
                {
                    using (var reader = new StreamReader(response.GetResponseStream()))
                    {
                        // Read & Desirialize object into a <key,ValueEvent> dictionary
                        string jsonString = reader.ReadToEnd();
                        var info = jsonConvert.Deserialize<Info>(jsonString);
                        return info.loc;
                    }
                }
            }
            catch (WebException ex)
            {
                return ex.Message;
            }
        }
		
		
	}
}
